% Run mooring scenarios and plot profiles

% Mean speed

Lombok2;
velocity = [ 0      0.50;
            -200    0.40;
		    -250	0.30;
		    -400	0.30;
		    -750	0.30;
		    -1500   0.30;
            -2200   0.30];

% Files

checkFile = 'Lombok2Mean';
mooringFile = 'Lombok2';

runmoor;
depthMean = depth;
hdistMean = hdist;
nodesMean = fnodes;

% Plot mooring

plmoor4

% Max speed profile

Lombok2;
velocity = [ 0      1.50;
            -200    1.00;
		    -250	0.75;
		    -400	0.75;
		    -750	0.75;
		    -1500   0.75;
            -2200   0.75];

% Print file

checkFile = 'Lombok2Max';

runmoor;
depthMax = depth;
hdistMax = hdist;
nodesMax = fnodes;

% Plot

figure(4);
clf
plot(hdistMean, -1. * depthMean, '-', 'linewidth', 1);
hold on
plot(hdistMax, -1. * depthMax, '-', 'linewidth', 1);
axis equal
set(gca, 'ylim', [0 -1*depthMax(1)]);
set(gca, 'xlim', [0 1500]);

text(nodesMean(end, 9), -1. * nodesMean(end, 5), ...
    [' ' num2str(-1. * nodesMean(end, 5), '%.0f')]);

text(nodesMax(end, 9), -1. * nodesMax(end, 5), ...
    [' ' num2str(-1. * nodesMax(end, 5), '%.0f')]);

for i=['nodesMean'; 'nodesMax ']'
   eval(['adcp = find(' i' '(:, 1) == 321);']);
   eval (['plot(' i' '(adcp,9),-1.*' i' '(adcp,5), ''bo'',''markerfacecolor'',''b'');']);
   eval (['text(' i' '(adcp,9),-1.*' i' '(adcp,5), num2str(-1.*' i' '(adcp,5),''%.0f''));']);
   eval(['rcms=find(' i' '(:,1)==308);']);
   eval (['plot(' i' '(rcms,9),-1.*' i' '(rcms,5), ''r<'',''markersize'',7)']);
end

set(gca, 'ydir', 'reverse');
xlabel('Horizontal Excursion (m)', 'fontsize', 12);
ylabel('Depth (m)', 'fontsize', 12);
set(gca, 'fontsize', 12, 'linewidth', 1);








